﻿/*
Macro_scripts for Layers
Created: Mark Young
Version: 3dsmax 6

Revision History:

	9 Juin 2003; Pierre-Felix Breton
		checked in max

	13 juin 2003; Pierre-Felix Breton
		optimizations suggested by Larry Minton
	
	17 Juin 2003; Pierre-Felix breton
		bug fixes and localization notes
		
	5 aout 2003; Pierre-Felix Breton
		bug fixes
		
	13 aout 2003; Pierre-Felix Breton
		bug fixes

	19 aout 2003; Pierre-Felix Breton
		bug fixes

	11 sept 2003; Mark Young
		added LayerPropertiesByLayer macro
		
	6 fevrier 2003; Pierre-Felix Breton
		added the following macros:
		Isolate SeleDction`s Layer:  isolates the layer of the selected objecs 
		Freeze Selection`s Layer: freeze the layers of the selected objects 
		Hide Selection`s Layer : hide the layers of the selected objects

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products


        19 dec 2003, Pierre-Felix Breton
                added VIZ Render scripts
*/

--Show Layer toolbar

macroScript LayerShowToolbar
	category:~LAYERSHOWTOOLBAR_CATEGORY~
	internalCategory: "Layers" --LOC_NOTES: do not localize this
	toolTip:~LAYERSHOWTOOLBAR_TOOLTIP~ --LOC_NOTES: localize this
	ButtonText:~LAYERSHOWTOOLBAR_BUTTONTEXT~ --LOC_NOTES: localize this

(
	on execute do
	(
		cui.showToolbar ~LAYERSHOWTOOLBAR_TARGETCAPTION~
	)
)

--Add selected Objects to Current Layer

macroScript LayerAdd
	category:~LAYERADD_CATEGORY~
	internalCategory: "Layers" --LOC_NOTES: do not localize this
	toolTip:~LAYERADD_TOOLTIP~ --LOC_NOTES: localize this
	ButtonText:~LAYERADD_BUTTONTEXT~ --LOC_NOTES: localize this
	iconName:"Layers/AddSelectionToCurrentLayer" --LOC_NOTES: do not localize this

(
	-- cost/benefit too high?
	on isEnabled do return (selection.count > 0) --13 juin 2003; Pierre-Felix Breton
	on execute do
	(
		local vLayer = LayerManager.current
		local vObjects = selection as array
		local vItem
		for vItem in vObjects do vLayer.addNode vItem
	)
)

/*
1 - Pops up dialog to get new Layer name from user (and option for adding selection)
2 - Creates new Layer with specified name
3 - Sets new Layer to be "Current Layer"
4 - Adds selected Objects to new Layer unless user opts out in #1 */
macroScript LayerCreate
	category:~LAYERCREATE_CATEGORY~ --LOC_NOTES: localize this
	internalCategory: "Layers" --LOC_NOTES: do not localize this
	toolTip:~LAYERCREATE_TOOLTIP~  --LOC_NOTES: localize this
	buttonText:~LAYERCREATE_BUTTONTEXT~   --LOC_NOTES: localize this
	iconName:"Layers/CreateNewLayer"    --LOC_NOTES: do not localize this
(
	-- set parameters in dialog creation method
	local vNameLayer

	-- create layer if name is unused
	-- assign name from "vNameLayer" - delete layer if this fails
	-- set new Layer as current
	-- add selected objects if "flagAddSelection" is true
	-- destroy dialog if naming succeeded
	function fCreateLayer flagAddSelection vNameLayer =
	(
		with undo label:~UNDO_LABEL_CAPTION~ on --LOC_NOTES: localize this
		(
			--checks for leading spaces:
			--compares the trimmed string with original string
			--if they are not the same, it means that spaces has been trimmed and the 
			--string do contains leading space, tabs or else, so the layer name is invlid
			vNameLayer = trimleft vNameLayer 
			vNameLayer = trimright vNameLayer 

			local vLayer = LayerManager.newLayerFromName(vNameLayer)
			if vLayer != undefined do -- undefined if duplicate name
			(
				vLayer.current = true
				if (flagAddSelection) do 
				(
					local vItem
					local scnExpl = SceneExplorerManager.GetActiveExplorer()
					if (scnExpl == undefined) then
					(
						for vItem in (selection as array) do vLayer.addNode vItem
					)
					else
					(
						local explSelection = scnExpl.selecteditems()
						for vItem in (explSelection) do 
						(
							if (classof vItem == Base_LayerBase_Layer) then (
								local selItemLayerIntf = getInterface vItem "LayerProperties"
								if (selItemLayerIntf != undefined) do
									selItemLayerIntf.setparent vLayer
							)
							else (
								vLayer.addNode vItem
							)
						)
					)
				)--end if flagAddSelection
			)
		)		
	)
	
	--this function determines if a string contains leading spaces
	--returns true or false based on the answer
	function isLayerNameValid strName =
	(
		strName = trimleft strName 
		strName = trimright strName 
		--assumes that the layer name is valid, flag to false if not
		local boolIsLayerNameValid = true
		
		--checks for an empty layer name:
		if (strName == "") do boolIsLayerNameValid = false
		
		--checks for existing name in the layers list:
		if (layermanager.getlayerfromname strName) != undefined do boolIsLayerNameValid = false
		--returns the flag
		boolIsLayerNameValid
	)

	-- dialog presented when nothing is selected
	-- gets name input and calls "fCreateLayer"
	-- calls "fCreateLayer" or destroys itself if cancelled
	rollout vRollout ~VROLLOUT_CAPTION~ width:240 height:80 --LOC_NOTES: localize this
	(
		edittext vEdittext ~VEDITTEXT_CAPTION~ text:vNameLayer pos:[25,15] width:195 --LOC_NOTES: localize this
		button vButtonOK ~VBUTTONOK_CAPTION~ pos:~VBUTTONOK_POSITION~ width:65 --LOC_NOTES: localize this
		button vButtonCancel ~VBUTTONCANCEL_CAPTION~ pos:~VBUTTONCANCEL_POSITION~ width:65 --LOC_NOTES: localize this
		checkbox vCheckbox ~VCHECKBOX_CAPTION~ checked:true pos:~VCHECKBOX_POSITION~ width:~VCHECKBOX_WIDTH~ height:~VCHECKBOX_HEIGHT~ --LOC_NOTES: localize this

		on vEdittext changed arg do 
		(
			vNameLayer = arg
			
			if (isLayerNameValid vNameLayer)  --prevent layers with empty names or leading spaces from being created: pfbreton 13 aout 2003
			then vButtonOK.enabled = true
			else vButtonOK.enabled = false
		)
		
		-- removes the ability to hit enter in the text field to prevent the unexpected exit of the dialog when 
		-- the control losts focus
		on vEdittext entered arg do 
		(
			setfocus vButtonOK
		)
		
		on vButtonOK pressed do 
		(
			vNameLayer = vEdittext.text
			fCreateLayer vCheckbox.checked vNameLayer
			destroyDialog vRollout 
		)
		on vButtonCancel pressed do 
		(
			destroyDialog vRollout
		)
		on vRollout open do 
		(	
			if (selection.count == 0) do vCheckbox.checked = false
			setfocus vEdittext
		)
		
	)

	-- get initial [automatic] name string
	-- read selection
	-- launch appropriate dialog
	on execute do
	(
		vNameLayer = LayerManager.getNextDefaultLayerName()
		local scnExpl = SceneExplorerManager.GetActiveExplorer()
		if (scnExpl == undefined) then
		(
			createDialog vRollout width:245 height:95
		)
		else
		(
			fCreateLayer true vNameLayer
		)
	)
)

-- Macro_LayerSelect.mcr - Select Objects in Current Layer

-- known issue: Does not work when Ctrl key is pressed ...

macroScript LayerSelect
	category:~LAYERSELECT_CATEGORY~ --LOC_NOTES: localize this
	internalCategory: "Layers" --LOC_NOTES: do not localize this
	toolTip:~LAYERSELECT_TOOLTIP~ --LOC_NOTES: localize this
	ButtonText:~LAYERSELECT_BUTTONTEXT~ --LOC_NOTES: localize this
	iconName:"Layers/SelectLayer" --LOC_NOTES: do not localize this
(
	on execute do
	(
		local vObjects
		LayerManager.current.nodes &vObjects
		if (keyboard.shiftPressed) then selectMore vObjects
		else select vObjects
		vObjects = undefined
	)
)

-- Macro_LayerSet.mcr - Set Current Layer to that containing Selection

macroScript LayerSet
	category:~LAYERSET_CATEGORY~ --LOC_NOTES: localize this
	internalCategory: "Layers" --LOC_NOTES: do not localize this
	toolTip:~LAYERSET_TOOLTIP~ --LOC_NOTES: localize this
	ButtonText:~LAYERSET_BUTTONTEXT~ --LOC_NOTES: localize this
	iconName:"Layers/SetLayer" --LOC_NOTES: do not localize this
(
	function fGetLayerContainingSelection = --13 juin 2003; Pierre-Felix Breton
	(
		local vLayer = undefined
		vLayer = selection[1].INodeLayerProperties.layer --using selection[1] is faster than copying the selection in an array
	)--end function

	-- cost/benefit too high?
	on isEnabled return (selection.count == 1) --13 juin 2003; Pierre-Felix Breton
	on execute do
	(
		local vLayer = fGetLayerContainingSelection()
		if (vLayer != undefined) do vLayer.current = true
		vLayer = undefined
	)
)

-----------------------------------------------
macroScript LayerManager 
	category:~LAYERMANAGER_CATEGORY~  --LOC_NOTES:localize this
	internalCategory: "Layers" --LOC_NOTES: do not localize this
	tooltip:~LAYERMANAGER_TOOLTIP~ --LOC_NOTES:localize this
	buttontext:~LAYERMANAGER_BUTTONTEXT~  --LOC_NOTES:localize this
	Icon:#("LayerToolbar",5)--LOC_NOTES: do not localize this
(
	on execute do
	(
		try layermanager.editlayerbyname ""	catch(messagebox ~MSGBOX_ERROR_RUNNING_LAYER_MANAGER~	) --LOC_NOTES:localize this
	)-- on execute
	on closeDialogs do
	(
		try layermanager.closeDialog() catch(messagebox ~CLOSE_DIALOG_MSGBOX_ERROR_RUNNING_LAYER_MANAGER~) --LOC_NOTES:localize this
	)
	on isChecked do
	(
		try layermanager.isDialogOpen() catch(messagebox ~IS_DIALOG_OPEN_MSGBOX_ERROR_RUNNING_LAYER_MANAGER~) --LOC_NOTES:localize this
	)
)--layer_manager


-- added following macro 11 sept 2003; mjyoung
---------------------
macroScript LayerPropertiesByLayer 
	category:~LAYERPROPERTIESBYLAYER_CATEGORY~ --LOC_NOTES:localize this
	internalCategory: "Layers" --LOC_NOTES:do not localize this
	tooltip:~LAYERPROPERTIESBYLAYER_TOOLTIP~ --LOC_NOTES:localize this
	buttontext:~LAYERPROPERTIESBYLAYER_BUTTONTEXT~ --LOC_NOTES:localize this
	Icon:#("LayerToolbar",6) --LOC_NOTES:do not localize this
(
	local hit_set, hit_item, n, i

	function CheckLayerState = 
	(
		trueStates = 0
		falseStates = 0
	
		hit_set = $selection
		if (hit_set != undefined) do 
		(
			n = hit_set.count
			for i=1 to n do 
			(
				try 
				(
					hit_item = hit_set[i]
					if (hit_item.displayByLayer) then trueStates += 1;
					else falseStates += 1;
					if (hit_item.renderByLayer) then trueStates += 1;
					else falseStates += 1;
					if (hit_item.motionByLayer) then trueStates += 1;
					else falseStates += 1;
					if (hit_item.colorByLayer) then trueStates += 1;
					else falseStates += 1;
					if (hit_item.globalIlluminationByLayer) then trueStates += 1;
					else falseStates += 1;
				)
				catch (
				)
				
			)
		)

		result = -1 -- inderminate
		if ( (trueStates > 0)  and   (falseStates == 0) ) then result = 1 -- checked
		if ( (falseStates > 0) and   (trueStates == 0) ) then result = 0 -- unchecked
		result 
	)
	
	on isEnabled return (selection.count > 0)
	
	on isIndeterminate do
	(
		 
		local val = CheckLayerState()
		if ( val == -1) then true else false
	)
	
	on isChecked do
	(
		local val = CheckLayerState()
		if ( val == 1) then true else false
	)

	on execute do (
		hit_set = $selection
		if (hit_set != undefined) do 
		(
			local setVal = true     -- if indeterminate set to true
			if (CheckLayerState() == 1) then
				setVal = false
			n = hit_set.count
			for i=1 to n do (
				try (
					hit_item = hit_set[i]
					hit_item.displayByLayer= setVal
					hit_item.renderByLayer= setVal
					hit_item.motionByLayer= setVal
					hit_item.colorByLayer= setVal
					hit_item.globalIlluminationByLayer = setVal
				)
				catch (
				)
			)
		)
	)-- on execute
) -- LayerPropertiesByLayer


-- //////////////////////////////////////////////////////////////////////////////
--  New layer tools for Design VIZ users - 6 feb 2003
--  Isolate Selection`s Layer:  isolates the layer of the selected objecs 
--  Freeze Selection`s Layer: freeze the layers of the selected objects 
--  Hide Selection`s Layer : hide the layers of the selected objects

macroScript LayerIsolate
	category:~LAYERISOLATE_CATEGORY~ --LOC_NOTES: localize this
	internalCategory: "Layers" --LOC_NOTES: do not localize this
	toolTip:~LAYERISOLATE_TOOLTIP~ --LOC_NOTES: localize this
	ButtonText:~LAYERISOLATE_BUTTONTEXT~ --LOC_NOTES: localize this
	--Icon:#("LayerToolbar",3) --LOC_NOTES: do not localize this
(
	on isEnabled return (selection.count > 0)

	on execute do
	(
	
		-- variables
		local count
		local i
		
		-- disable scene redraw to prevent a bunch of flashing.
		with redraw off
		(
			--build an array containing the layers associated with the current selection
			local vObjects = selection as array
			
			
			-- turn off all the layers as an initial step
			count = layermanager.count - 1
			for i = 0 to count do
			(
				layer = layermanager.getlayer i
				layer.on = false
			)--end for
	
	
			--turn on all layers associated with the selection
			for i in vObjects do
			(
				i.layer.on = true		
			)--end for
			
		)--end with redraw off
		
	)-- end on execute
)--end macro

macroScript LayerFreeze
	category:~LAYERFREEZE_CATEGORY~ --LOC_NOTES: localize this
	internalCategory: "Layers" --LOC_NOTES: do not localize this
	toolTip:~LAYERFREEZE_TOOLTIP~ --LOC_NOTES: localize this
	ButtonText:~LAYERFREEZE_BUTTONTEXT~ --LOC_NOTES: localize this
	--Icon:#("LayerToolbar",3) --LOC_NOTES: do not localize this
(
	on isEnabled return (selection.count > 0)
	on execute do
	(
		-- variables
		local i
		
		-- disable scene redraw to prevent a bunch of flashing.
		with redraw off
		(		
			local vObjects = selection as array
			for i in vObjects do
			(
				i.layer.lock = true		
			)--end for
			
		)--end with redraw off	
	)-- end on execute
)--end macro

macroScript LayerHide
	category:~LAYERHIDE_CATEGORY~ --LOC_NOTES: localize this
	internalCategory: "Layers" --LOC_NOTES: do not localize this
	toolTip:~LAYERHIDE_TOOLTIP~ --LOC_NOTES: localize this
	ButtonText:~LAYERHIDE_BUTTONTEXT~ --LOC_NOTES: localize this
	--Icon:#("LayerToolbar",3) --LOC_NOTES: do not localize this
(
	on isEnabled return (selection.count > 0)
	on execute do
	(
		-- variables
		local i
		
		-- disable scene redraw to prevent a bunch of flashing.
		with redraw off
		(		
			local vObjects = selection as array
			for i in vObjects do
			(
				i.layer.on = false
			)--end for
			
		)--end with redraw off	
	)-- end on execute
)--end macro


macroScript SceneExplorerParentNode
	category:~LAYERCREATE_CATEGORY~ --LOC_NOTES: localize this
	internalCategory: "Layers" --LOC_NOTES: do not localize this
	toolTip:~SCENEEXPLORER_PARENTNODE_TOOLTIP~  --LOC_NOTES: localize this
	buttonText:~SCENEEXPLORER_PARENTNODE_BUTTONTEXT~   --LOC_NOTES: localize this
	-- @todo: get an icon for the command...
	--	icon:#("LayerToolbar",1)    --LOC_NOTES: do not localize this
(
	fn FilterNodeAndLayers scnExpltem =
	(
		(classof scnExpltem == Base_LayerBase_Layer or 
			(IsValidNode(scnExpltem) and (not scnExpltem.isSelected)))
	)

	fn FilterLayers scnExpltem =
	(
		(classof scnExpltem == Base_LayerBase_Layer)
	)

	fn SceneExplorerSelectionContainsOnlyLayers scnExpl =
	(
		result = true
		if (scnExpl == undefined) then
		(
			result = false
		)
		else
		(
			count = 0
			for item in (scnExpl.selecteditems()) where (classof item != Base_LayerBase_Layer) do (
				count += 1
			)
			if (count > 0) do
				result = false
		)
		result
	)

	-- returns whether testNode is a parent of refNode
	function IsParent refNode testNode =
	(
		local parentNode = refNode.parent
		
		local keepgoing = true
		result = false
		while ((parentNode != undefined) and (keepgoing)) do
		(
			if parentNode == testNode then
			(
				result = true
				keepgoing = false
			)
			parentNode = parentNode.parent
		)
		result
	)

	-- returns whether layerToTest is a parent of refLayer
	function IsParentLayer refLayer layerToTest =
	(
		local parentLayer = refLayer.getparent()
		local keepgoing = true
		result = false
		while ((parentLayer != undefined) and (keepgoing)) do
		(
			if parentLayer == layerToTest do 
			(
				result = true
				keepgoing = false
			)
			parentLayer = parentLayer.getparent()
		)
		result
	)

	on isEnabled do
	(
		local scnExpl = SceneExplorerManager.GetActiveExplorer()
		(scnExpl == undefined OR (scnExpl.selecteditems()).count > 0)
	)

	on execute do
	(
		-- Get the active explorer, which should be the one that launched the command
		-- Otherwise just use the current scene selection
		local explSelection
		local scnExpl = SceneExplorerManager.GetActiveExplorer()
		if (scnExpl != undefined) then (
			explSelection = scnExpl.selecteditems()
		)
		else (
			explSelection = selection
		)
		if (explSelection.count > 0) then (
			-- pick a single node or layer to act as parent to the selection
			local filterFn
			-- if the explorer selection contains only layers then only layers should be pickable
			if (SceneExplorerSelectionContainsOnlyLayers scnExpl) then (
				filterFn = FilterLayers
			)
			else (
				filterFn = FilterNodeAndLayers
			)
			local pickedItem = pickAnimatable message:~SCENEEXPLORER_PARENTNODE_PICKTEXT~ filter:filterFn
			if (pickedItem != undefined and pickedItem != #escape) then (
				local layerPicked = (classof pickedItem == Base_LayerBase_Layer)
				local vItem
				for vItem in (explSelection) do (
					if (classof vItem == Base_LayerBase_Layer) then (
						if (layerPicked) then (
							local pickedLayerIntf = getInterface pickedItem "LayerProperties"
							local selItemLayerIntf = getInterface vItem "LayerProperties"
							if (selItemLayerIntf != undefined and 
								selItemLayerIntf != pickedLayerIntf and
								(not IsParentLayer pickedLayerIntf selItemLayerIntf)
							) do
								selItemLayerIntf.setparent pickedLayerIntf
						)
					)
					else (
						if (layerPicked) then (
							local pickedLayerIntf = getInterface pickedItem "LayerProperties"
							if (pickedLayerIntf != undefined) do
								pickedLayerIntf.addNode vItem
						)
						else if (not IsParent pickedItem vItem) do
						(
							vItem.parent = pickedItem
						)
					)
				)
			)
		)
	)--end execute
)

macroScript SceneExplorerSetActiveLayerAsParentLayer
	category:~LAYERCREATE_CATEGORY~ --LOC_NOTES: localize this
	internalCategory: "Layers" --LOC_NOTES: do not localize this
	toolTip:~SCENEEXPLORER_ACTIVELAYERASPARENTLAYER_TOOLTIP~  --LOC_NOTES: localize this
	buttonText:~SCENEEXPLORER_ACTIVELAYERASPARENTLAYER_BUTTONTEXT~   --LOC_NOTES: localize this
	-- @todo: get an icon for the command...
	--	icon:#("LayerToolbar",1)    --LOC_NOTES: do not localize this
(
	-- returns whether layerToTest is a parent of refLayer
	function IsParentLayer refLayer layerToTest =
	(
		local parentLayer = refLayer.getparent()
		local keepgoing = true
		result = false
		while ((parentLayer != undefined) and (keepgoing)) do
		(
			if parentLayer == layerToTest do 
			(
				result = true
				keepgoing = false
			)
			parentLayer = parentLayer.getparent()
		)
		result
	)

	on isEnabled do
	(
		local scnExpl = SceneExplorerManager.GetActiveExplorer()
		(scnExpl != undefined AND scnExpl.IsLayerView() AND (scnExpl.selecteditems()).count > 0)
	)

	on execute do
	(
		-- Get the active explorer, which should be the one that launched the command
		local scnExpl = SceneExplorerManager.GetActiveExplorer()
		local explSelection = if (scnExpl != undefined) then ( scnExpl.selecteditems() ) else ( #() )
		local newParentLayer = layermanager.current
		for vItem in (explSelection) do (
			if (classof vItem == Base_LayerBase_Layer) then (
				local selItemLayerIntf = getInterface vItem "LayerProperties"
				if (selItemLayerIntf != undefined and 
					selItemLayerIntf != newParentLayer and
					(not IsParentLayer newParentLayer selItemLayerIntf)
				) do
					selItemLayerIntf.setparent newParentLayer
			)
			else (
				newParentLayer.addNode vItem
			)
		)
	)--end execute
)

-- //////////////////////////////////////////////////////////////////////////////

-- end of file

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQDFIgtrHgqZzcjF74mfe70SNqCkWMtwBe/9
-- Mm+p+OsW7veZ8dhzHuevs39St+NA5HHBVC8aDutg0cY3l2JqODW6E40LKMSzx4Wt
-- wkeARnkPmFCqzdRSB2lCV/gilJn6qRChBRTbWIcSdSwC2GVsvVP7b84k+puMgu5k
-- OPnLU5hkatPie8aGd2cH3bdmMX6eYjiwRtPM1z/tB6oEyfKPPg/WdwCogEiv4+Gt
-- ygILBLgSbi5lGmddLiS7b+dTq2vN8T2dK0XckoIm93RKVGFsbP6YhoyCOR+In6Zu
-- SybEMEiskic0ZthD83l1oXFgtXvkMeQCFB0Iaa/Uk31FMHZBsk/n
-- -----END-SIGNATURE-----